﻿#using System.IO;
#using Tessa.Workflow.Actions;
#using Tessa.Cards;

if (!ActionHash.ContainsKey("WeTaskActionTaskRoles"))
{
	ActionHash.Add("WeTaskActionTaskRoles", new List<object>());
}

ActionHash
	.Get<IList>("WeTaskActionTaskRoles")
	.Add(
		new Dictionary<string, object?>
	    {
	        { "RowID", Guid.NewGuid() },
	        {
	            "TaskRole",
	            new Dictionary<string, object>
	            {
	                { "ID", CardFunctionRoles.PerformerID },
	                { "Caption", "$Enum_FunctionRoles_Performer" }
	            }
	        },
	        {
	            "RoleSelectionMode",
	            new Dictionary<string, object>
	            {
	                { "ID", (int) WorkflowActionRoleSelectionMode.Role },
	                { "Name", "$WorkflowEngine_TaskRoleSelectionModes_Role" }
	            }
	        },
	        { "Master", true },
	        { "ShowInTaskDetails", false },
	        {
	            "Role",
	            new Dictionary<string, object>
	            {
	                { "ID", Context.Session.User.ID },
	                { "Name", Context.Session.User.Name }
	            }
	        },
	    });
